require( "quest/m2_bakery/convout.lua" );
combine_speech_tables();

function bakery_intro(flo)
	
	coroutine.yield(RESUME.ON_CLICK);
	coroutine.yield(RESUME.ON_MOUSE_NOT_DOWN);
	scene:DisplayFlash("flash/bakery2_intro.swf");
	wait_subscene();
	scene.STELLA:JumpToNamedPoint("bakery2");
	scene.STELLA:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.STELLA:PlayAnim("stand");
	game:Set("first_time_bakery", 1);
	flo:SetMode(MODE.FOLLOWCLICKS);
	
end

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

function flo_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("mg_trilock_activity_round") < 1 then
		run_super_conversation(flo, "quip_bakery_A");
	elseif game:Get("got_recipe") < 1 then
		run_super_conversation(flo, "quip_bakery_B");
	elseif game:Get("visited_kitchen") < 1 then
		run_super_conversation(flo, "quip_bakery_C1");
	elseif not quest_complete("cake") then
		run_super_conversation(flo, "quip_bakery_C");
	else
		run_super_conversation(flo, "quip_bakery_D");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:SetWalkSpeed(flo_speed);
		
		local lastScene = game:GetLastScene();
		
		actor:JumpToNamedPoint("flo");
		actor:FaceNow(DIR.SE);
		
-- ** TRIANGLE PUZZLE ** --
		if lastScene == "mg_triangle" then
			coroutine.yield(RESUME.NOW); -- wait a frame
			actor:FaceActor(scene.RECIPEBOX);
			wait_fade();
			
			if game:Get("mg_trilock_activity_round") < 2 then
				run_super_conversation(actor, "quip_failed_box");
			else
				if game:Get("unlocked_recipe_box") < 1 then
					addInventory(inv_desc_recipe);
					run_super_conversation(actor, "conv_got_recipe");
					complete_quest("get_recipe", false);
					add_quest("get_ingredients");
					wait_subscene();
					game:Set("unlocked_recipe_box", 1);
				end
			end
			actor:SetMode(MODE.FOLLOWCLICKS);
-- ** KITCHEN ** --
		elseif lastScene == "m2_kitchen" then
			wait_fade();
			if game:Get("cake_first_attempt") < 1 then
				run_super_conversation(actor, "conv_bakery_not_done");
				game:Set("cake_first_attempt", 1);
			end
			
			if quest_added("get_eggs") and game:Get("talked_to_stella_about_eggs") < 1 then
				run_super_conversation(actor, "conv_need_eggs");
				game:Set("talked_to_stella_about_eggs", 1);
				add_quest("check_farm");
				wait_subscene();
				actor:SetMode(MODE.FOLLOWCLICKS);
			elseif game:Get( "cake_delivered" ) ~= 1 and game:Get( "cake_done" ) == 1 then				
				scene:SetFadeTarget { a = 1, r = 0, g = 0, b = 0 };
				scene:SetFadeSpeed(0.05);
				scene:SetMusicVolumeSpeed(0.05);
				wait_fade();
				
				sfx:SetMusic("audio/music/music_delivery_movies.ogg", true);
				scene:DisplayFlash("flash/deliverycut_scene_cake_intro.swf");
				wait_subscene();	
				game:Set( "cake_delivered", 1 );
				game:Set("cake_just_delivered", 1);
				scene:ChainTo("m2_sizzle1");
			else
				actor:SetMode(MODE.FOLLOWCLICKS);
			end
-- ** SIZZLE/ANYTHING ELSE ** --
		else
			actor:JumpToNamedPoint("sizzle1");
			actor:FaceNow(DIR.E);
			actor:WalkTo("flo");
			wait_walkto();
			
			actor:Face(DIR.SE);
			
			if game:Get("first_time_bakery") < 1 then	
				run_super_conversation(actor, "conv_bakery_intro");
				--bakery_intro(actor);
				complete_quest("check_with_stella", false);
				add_quest("get_recipe");
				wait_subscene();
				game:Set("first_time_bakery", 1);
			else
				if BAG_INV:CheckInventory("eggs") and game:Get("told_stella_found_eggs") < 1 then -- just got eggs
					run_super_conversation(actor, "conv_got_eggs");
					game:Set("told_stella_found_eggs", 1)
				end;
				
				if quest_complete("use_cake_instructions") and game:Get("told_stella_watched_tape") < 1 then -- just watched tape
					run_super_conversation(actor, "conv_watched_tape");
					game:Set("told_stella_watched_tape", 1);
				end;
			end
			actor:SetMode(MODE.FOLLOWCLICKS);
		end;
		
		if game:Get( "cake_done" ) < 1 then
			spawn_nav_arrow(kitchen_door_spec);
		end
		actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(flo_conv);
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function recipebox(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("got_recipe") < 1 then
		if game:Get("already_clicked_on_recipe_box") < 1 then
			run_super_conversation(flo, "quip_pickup_box");
			game:Set("already_clicked_on_recipe_box", 1);
		end
		goto_scene(flo, "mg_triangle");
	else
		run_super_conversation(flo, "quip_use_box_again");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end

recipebox_spec = 
{
	name = "RECIPEBOX";
	halo = "recipebox";
	gfx = { image = "recipebox" };
	
	command = function(actor)
		actor:SetDepthValue(265);
	end;
	
	on_arrive = function(flo, actor)
		flo:FaceActor(actor);
		flo:StartProc(recipebox);
	end;
}

stella_anim_table =
{
	"anim/stella/stand",
	"anim/stella/talk",
};

function stella_conv(flo, stella)
	flo:SetMode(MODE.CUTSCENE);
	if not quest_complete("get_recipe") then
		run_super_conversation(flo, "conv_stella_A");
	elseif game:Get("visited_kitchen") < 1 then
		run_super_conversation(flo, "conv_stella_B");
	elseif game:Get("visited_farm") < 1 then
		if quest_added("get_eggs") then
			run_super_conversation(flo, "conv_stella_C");
		end
	elseif not quest_added("use_cake_instructions") then
		run_super_conversation(flo, "conv_stella_D");
	elseif not quest_complete("use_cake_instructions") then
		run_super_conversation(flo, "conv_stella_E");
	elseif not quest_complete("cake") then
		run_super_conversation(flo, "conv_stella_F");
	else
		run_super_conversation(flo, "conv_stella_G");
	end
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

stella_spec = 
{
	name = "STELLA";
	halo = "quest/objects/stellaw";
	anim = stella_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, stella_text_spec);
		--actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		
		actor:JumpToNamedPoint("stella1");
		actor:FaceNow(DIR.W);
		
		if game:Get("got_recipe") < 1 then
			actor:LastingEmotion();
			actor:SetEmotion("sad");
		end
	end;
	
	on_arrive = function(flo, stella)
		flo:FaceActor(stella);
		flo:StartProc(stella_conv);
	end;
	
	on_use_inv = function(item, flo, stella)
		if item == "vhstape" then
			convproc("FLO", "quip_bakery_video_A");
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
	
};

function kitchen_door(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("visited_kitchen") < 1 and game:Get("got_recipe") < 1 then
		run_super_conversation(flo, "quip_kitchen_door_A");
		flo:SetMode(MODE.FOLLOWCLICKS);
	elseif game:Get("got_recipe") then
		if game:Get("visited_kitchen") < 1 then
			game:Set("visited_kitchen", 1);
			run_super_conversation(flo, "quip_kitchen_door_B");
		end
		goto_scene(flo, "m2_kitchen");
	else
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end

kitchen_door_spec = 
{
	name = "KITCHEN_DOOR";
	halo = "kitchen_door";
	cursor = "cursor_arrow_e";
	
	goto_fn = kitchen_door;
	point_at_fn = function(actor, enter)
		if actor:GetMode() ~= MODE.CUTSCENE then
			if enter then
				scene.BACK_DOOR:PlayAnim("Open");
			else
				scene.BACK_DOOR:PlayAnim("Close");
			end
		end
	end;
};


right_displaycase_lastconv = false;
right_displaycase_spec = 
{
	name = "RIGHT_DISPLAYCASE";
	halo = "right_displaycase";
	
	command = function(actor)
		actor:SetDepthValue(400);
	end;
	
	on_arrive = function(flo, actor)
		if right_displaycase_lastconv == false then
			convproc("FLO", "quip_display1_A");
			right_displaycase_lastconv = true;
		else
			convproc("FLO", "quip_display1_B");
			right_displaycase_lastconv = false;
		end
	end;
};

left_displaycase_lastconv = false;
left_displaycase_spec = 
{
	name = "LEFT_DISPLAYCASE";
	halo = "left_displaycase";
	
	command = function(actor)
		actor:SetDepthValue(400);
	end;
	
	on_arrive = function(flo, actor)
		if left_displaycase_lastconv == false then
			convproc("FLO", "quip_display2_A");
			left_displaycase_lastconv = true;
		else
			convproc("FLO", "quip_display2_B");
			left_displaycase_lastconv = false
		end
	end;
};

function gotosizzle1(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("sizzle1");
	wait_walkto();
	goto_scene(flo, "m2_sizzle1");
end

to_sizzle1_spec = 
{
	name = "TO_SIZZLE1";
	halo = "to_sizzle1";
	cursor = "cursor_arrow_w";
	goto_fn = gotosizzle1;
}

back_door_spec =
{
	name = "BACK_DOOR";
	gfx = {anim = "anim/m2_bakery/back_door"};
	
	command = function(actor)
		actor:PlayAnim("Closed");
		actor:SetDepthValue("1");
	end
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/petspamusic.ogg", true);
		scene:SetRoomScale(300, 500, 0.9, 1.0);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up();
		
		if IsCheatMode() then
			--addInventory(inv_desc_recipe);
			--game:Set("triangle_unlocked", 1);
			--game:Set("found_recipebox", 1);
			--game:Set("visited_farm", 1);
			--game:Set("cake_done", 1);
			--addInventory(inv_desc_eggcarton);
			--BAG_INV:AddInventory(inv_desc_eggs);
			--BAG_INV:AddInventory(inv_desc_cookies);
			--addInventory(inv_desc_vhstape);
			-- testing data
			--complete_quest("cake");
		end
		
		spawn_nav_arrow(to_sizzle1_spec);
		
		spawn_simple_hotspot("bakery_coffee", 5);
		spawn_simple_hotspot("bakery_flowers", 5);
		
		game:SetString("map_position", "m2_bakery");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
				
		{ "counter", 388 },
		{ "bakery_cookies", 389 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		stella_spec,
		recipebox_spec,
		right_displaycase_spec,
		left_displaycase_spec,
		back_door_spec,
		
		scene_setup,
	};
};
